<?php declare(strict_types=1);

namespace MSwoft\Processor;

use MSwoft\Contract\SwoftInterface;
use MSwoft\SwoftApplication;

/**
 * Abstract processor
 *
 * @since 2.0
 */
abstract class Processor implements ProcessorInterface
{
    /**
     * Swoft application
     *
     * @var SwoftInterface|SwoftApplication
     */
    protected $application;

    /**
     * Processor constructor.
     *
     * @param SwoftInterface $application
     */
    public function __construct(SwoftInterface $application)
    {
        $this->application = $application;
    }
}
