<?php declare(strict_types=1);

namespace MSwoft\Processor;

use Swoft;
use MSwoft\Event\ListenerRegister;
use MSwoft\Event\Manager\EventManager;
use MSwoft\Log\Helper\CLog;
use MSwoft\SwoftEvent;
use function bean;

/**
 * Event processor
 *
 * @since 2.0
 */
class EventProcessor extends Processor
{
    /**
     * Handle event register
     *
     * @return bool
     */
    public function handle(): bool
    {
        if (!$this->application->beforeEvent()) {
            CLog::warning('Stop event processor by beforeEvent return false');
            return false;
        }

        /** @var EventManager $eventManager */
        $eventManager = bean('eventManager');
        [$count1, $count2] = ListenerRegister::register($eventManager);

        CLog::info('Event manager initialized(%d listener, %d subscriber)', $count1, $count2);

        // Trigger a app init event
        Swoft::trigger(SwoftEvent::APP_INIT_COMPLETE);

        return $this->application->afterEvent();
    }
}
