<?php declare(strict_types=1);

namespace MSwoft\Listener;

use MSwoft\Console\Console;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Server\Event\ServerStartEvent;
use MSwoft\Server\SwooleEvent;
use MSwoft\Stdlib\Helper\Sys;
use Swoole\Process;

/**
 * Class MasterStartListener
 *
 * @Listener(event=SwooleEvent::START)
 */
class MasterStartListener implements EventHandlerInterface
{
    /**
     * @param EventInterface|ServerStartEvent $event
     */
    public function handle(EventInterface $event): void
    {
        // Dont handle on mac OS
        if (Sys::isMac()) {
            return;
        }

        $server = $event->coServer;

        // Listen signal: Ctrl+C (SIGINT = 2)
        Process::signal(2, function () use ($server) {
            Console::colored("\nStop server by CTRL+C");
            $server->shutdown();
        });
    }
}
