<?php declare(strict_types=1);

namespace MSwoft\Listener;

use MSwoft\Console\Console;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Server\Event\ServerStartEvent;
use MSwoft\Server\SwooleEvent;

/**
 * Class ManagerStartListener
 *
 * @since 2.0
 *
 * @Listener(SwooleEvent::MANAGER_START)
 */
class ManagerStartListener implements EventHandlerInterface
{
    /**
     * @param EventInterface|ServerStartEvent $event
     */
    public function handle(EventInterface $event): void
    {
        $server = $event->coServer;

        Console::writef('Server start success (Master PID: <mga>%d</mga>, Manager PID: <mga>%d</mga>)',
            $server->master_pid, $server->manager_pid);
    }
}
