<?php declare(strict_types=1);

namespace MSwoft\Listener;

use MSwoft\Context\Context;
use MSwoft\Context\TimerTickContext;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\SwoftEvent;

/**
 * Class BeforeTimerTickListener
 *
 * @since 2.0
 *
 * @Listener(event=SwoftEvent::TIMER_TICK_BEFORE)
 */
class BeforeTimerTickListener implements EventHandlerInterface
{
    /**
     * Event name
     */
    public const EVENT_NAME = 'timerTick';

    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        [$timerId, $params] = $event->getParams();
        $context = TimerTickContext::new($timerId, $params);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => self::EVENT_NAME,
                'uri'         => (string)$timerId,
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
