<?php declare(strict_types=1);

namespace MSwoft\Listener;

use MSwoft\Context\Context;
use MSwoft\Context\TimerAfterContext;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\SwoftEvent;

/**
 * Class BeforeTimerAfterListener
 *
 * @since 2.0
 *
 * @Listener(event=SwoftEvent::TIMER_AFTER_BEFORE)
 */
class BeforeTimerAfterListener implements EventHandlerInterface
{
    /**
     * Event name
     */
    public const EVENT_NAME = 'timerAfter';

    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        $context = TimerAfterContext::new(1, []);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => self::EVENT_NAME,
                'uri'         => (string)1,
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
