<?php declare(strict_types=1);

namespace MSwoft\Listener;

use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\Server\Server;
use MSwoft\Server\ServerEvent;
use function implode;

/**
 * Class BeforeStartListener
 * @Listener(ServerEvent::BEFORE_START)
 */
class BeforeStartListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        /** @var Server $server */
        $server = $event->getTarget();

        CLog::info('Server extra info: pidFile <info>%s</info>', $server->getPidFile());
        CLog::info("Registered swoole events:\n <info>%s</info>", implode(', ', $event->getParam(0)));
    }
}
