<?php declare(strict_types=1);

namespace MSwoft\Listener;

use Swoft;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\SwoftEvent;

/**
 * Class AfterTimerAfterListener
 *
 * @since 2.0
 *
 * @Listener(event=SwoftEvent::TIMER_AFTER_AFTER)
 */
class AfterTimerAfterListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        // Defer
        Swoft::trigger(SwoftEvent::COROUTINE_DEFER);

        // Destroy
        Swoft::trigger(SwoftEvent::COROUTINE_COMPLETE);
    }
}
