<?php declare(strict_types=1);

namespace MSwoft\Error\Listener;

use Swoft;
use MSwoft\Error\ErrorManager;
use MSwoft\Error\ErrorRegister;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\SwoftEvent;

/**
 * Class WorkerStartListener
 *
 * @since 2.0
 * @Listener(SwoftEvent::APP_INIT_COMPLETE)
 */
class AppInitCompleteListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        /** @var ErrorManager $chain */
        $chain = Swoft::getSingleton(ErrorManager::class);

        // Register error handlers
        $count  = ErrorRegister::register($chain);
        $msgTpl = 'Error manager init completed(%d type, %d handler, %d exception)';

        CLog::info($msgTpl, $chain->getTypeCount(), $count, $chain->getCount());
    }
}
