<?php declare(strict_types=1);

namespace MSwoft\Error;

use MSwoft\Error\Contract\DefaultErrorHandlerInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\Stdlib\Helper\PhpHelper;
use Throwable;

/**
 * Class DefaultExceptionHandler
 *
 * @since 2.0
 */
class DefaultExceptionHandler implements DefaultErrorHandlerInterface
{
    /**
     * @param Throwable $e
     *
     * @return void
     */
    public function handle(Throwable $e): void
    {
        // Log::error($e->getMessage()); // maybe not in co env.
        $error = PhpHelper::exceptionToString($e, 'DEFAULT HANDLER', true);

        CLog::error($error);
    }

    /**
     * @return int
     */
    public function getType(): int
    {
        return ErrorType::DEF;
    }
}
