<?php declare(strict_types=1);

namespace MSwoft\Error\Annotation\Parser;

use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Annotation\Exception\AnnotationException;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Error\Annotation\Mapping\ExceptionHandler;
use MSwoft\Error\ErrorRegister;

/**
 * Class ExceptionHandlerParser
 *
 * @since 2.0
 * @AnnotationParser(ExceptionHandler::class)
 */
class ExceptionHandlerParser extends Parser
{
    /**
     * Parse object
     *
     * @param int              $type       Class or Method or Property
     * @param ExceptionHandler $annotation Annotation object
     *
     * @return array
     *
     * Return empty array is nothing to do!
     * When class type return [$beanName, $className, $scope, $alias] is to inject bean
     * When property type return [$propertyValue, $isRef] is to reference value
     * @throws AnnotationException
     */
    public function parse(int $type, $annotation): array
    {
        if ($type !== self::TYPE_CLASS) {
            throw new AnnotationException('`@ExceptionHandler` must be defined on class!');
        }

        $handlerClass = $this->className;

        ErrorRegister::add($handlerClass, $annotation->getExceptions());

        return [$handlerClass, $handlerClass, Bean::SINGLETON, ''];
    }
}
