<?php declare(strict_types=1);

namespace MSwoft\Console;

use Swoft;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Console\Contract\ConsoleErrorHandlerInterface;
use MSwoft\Console\Exception\ConsoleErrorException;
use MSwoft\Console\Helper\Show;
use MSwoft\Error\ErrorManager;
use MSwoft\Error\ErrorType;
use Throwable;
use function output;

/**
 * Class ConsoleErrorDispatcher
 *
 * @since 2.0.3
 * @Bean()
 */
class ConsoleErrorDispatcher
{
    /**
     * @param Throwable $e
     */
    public function run(Throwable $e): void
    {
        /** @var ErrorManager $manager */
        $manager = Swoft::getSingleton(ErrorManager::class);

        /** @var ConsoleErrorHandlerInterface $handler */
        if ($handler = $manager->matchHandler($e, ErrorType::CLI)) {
            $handler->handle($e);
            return;
        }

        // Console tips error
        if ($e instanceof ConsoleErrorException) {
            Show::error($e->getMessage());
            return;
        }

        // Ensure no buffer
        output()->clearBuffer();
        output()->flush();
        output()->writef(
            "<error>(CONSOLE)%s: %s</error>\nAt %s line <cyan>%d</cyan>\n<comment>Code Trace:</comment>\n%s",
            get_class($e), $e->getMessage(), $e->getFile(), $e->getLine(), $e->getTraceAsString()
        );
    }
}
