<?php declare(strict_types=1);

namespace MSwoft\Console;

use Swoft;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Console\Input\Input;
use MSwoft\Console\Output\Output;
use MSwoft\Context\AbstractContext;
use Throwable;
use function bean;
use function uniqid;

/**
 * Class ConsoleContext
 *
 * @since 2.0
 * @Bean(scope=Bean::PROTOTYPE)
 */
class ConsoleContext extends AbstractContext
{
    /**
     * @return ConsoleContext
     * @throws Throwable
     */
    public static function new(): self
    {
        /** @var self $ctx */
        $ctx = bean(static::class);

        $ctx->setMulti([
            'parentid' => '',
            'spanid'   => uniqid('', false),
            'traceid'  => uniqid('', false),
        ]);

        return $ctx;
    }

    /**
     * @return Input
     * @throws Throwable
     */
    public function getInput(): Input
    {
        return Swoft::getSingleton('input');
    }

    /**
     * @return Output
     * @throws Throwable
     */
    public function getOutput(): Output
    {
        return Swoft::getSingleton('output');
    }
}
