<?php declare(strict_types=1);

namespace MSwoft\Cache;

use MSwoft\Cache\Annotaion\Mapping\CacheMethod;

class CacheMethodRegister
{
    /**
     * @var array
     */
    private static $methods = [];

    /**
     * @param string $className
     * @param string $methodName
     * @param $objAnnotation
     */
    public static function registerMethod(string $className, string $methodName, $objAnnotation): void
    {
        self::$methods[$className . '@' . $methodName] = $objAnnotation;
    }

    /**
     * @return array
     */
    public static function getMethods(): array
    {
        return self::$methods;
    }

    public static function getAnnotation(string $className, string $methodName): ?CacheMethod
    {
        return self::$methods[$className . '@' . $methodName] ?? null;
    }
}
