<?php declare(strict_types=1);


namespace MSwoft\Cache;


use Closure;
use MSwoft\Stdlib\Helper\PhpHelper;

class CacheHelper
{
    public static function get(string $key, int $ttl, Closure $closure)
    {
        $cache     = bean("cacheManager");
        $cacheData = $cache->get($key);
        if (!is_null($cacheData)) {
            return $cacheData;
        }

        $ttl = $ttl ?? 300;
        $ret = PhpHelper::call($closure);
        // 后置通知
        $cache->set($key, $ret, $ttl);

        return $ret;
    }
}