<?php declare(strict_types=1);

namespace MSwoft\Cache\Annotaion\Parser;

use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Cache\Annotaion\Mapping\CacheMethod;
use MSwoft\Cache\CacheMethodRegister;

/**
 * @since 2.0
 *
 * @AnnotationParser(annotation=CacheMethod::class)
 */
class CacheMethodParser extends Parser
{
    public function parse(int $type, $annotationObject): array
    {
        CacheMethodRegister::registerMethod($this->className, $this->methodName, $annotationObject);

        return [];
    }
}
