<?php declare(strict_types=1);

namespace MSwoft\Cache\Annotaion\Mapping;

/**
 * Class Cron
 *
 * @since 2.0
 *
 * @Annotation
 * @Target("METHOD")
 * @Attributes({
 *     @Attribute("value", type="string"),
 *     @Attribute("ttl", type="int"),
 *     @Attribute("ctx", type="bool"),
 *     @Attribute("key", type="string")
 * })
 */
class CacheMethod
{
    /**
     * @var string
     */
    private $value = '';

    /**
     * @var int
     */
    private $ttl = null;

    /**
     * @var bool
     */
    private $ctx = false;

    /**
     * @var string
     */
    private $key = '';

    /**
     * Validator constructor.
     *
     * @param array $values
     */
    public function __construct(array $values)
    {
        if (isset($values['value'])) {
            $this->value = $values['value'];
        }
        if (isset($values['key'])) {
            $this->key = strval($values['key']);
        }
        if (isset($values['ttl'])) {
            $this->ttl = $values['ttl'];
        } else {
            $this->ttl = 300;
        }
        if (isset($values['ctx'])) {
            $this->ctx = boolval($values['ctx']);
        } else {
            $this->ctx = false;
        }
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @return int|null
     */
    public function getTTL(): ?int
    {
        return $this->ttl;
    }

    /**
     * @return bool|null
     */
    public function getCtx(): ?bool
    {
        return $this->ctx;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }
}
