<?php

namespace MSwoft\Beanstalk\Overwrite;

use Pheanstalk\Contract\SocketInterface;
use Pheanstalk\Exception\ConnectionException;
use Pheanstalk\Exception\SocketException;
use Swoole\Coroutine\Socket;

class SocketSocket implements SocketInterface
{
    private $socket;

    /**
     * Command timeout
     * @var float
     */
    private $timeout;

    public function __construct(string $host, int $port, float $connectTimeout, float $timeout)
    {
        $this->timeout = $timeout;
        $this->socket  = new Socket(AF_INET, SOCK_STREAM, 0);
        $retval        = $this->socket->connect($host, $port, $connectTimeout);
        if (!$retval) {
            throw new ConnectionException(0, "Failed to connect socket");
        }
    }

    private function throwException()
    {
        throw new SocketException($this->socket->errMsg, $this->socket->errCode);
    }

    public function write(string $data): void
    {
        while (!empty($data)) {
            $written = $this->socket->send($data, $this->timeout);
            if ($written === false) {
                $this->throwException();
            }
            $data = substr($data, $written);
        }
    }

    public function read(int $length): string
    {
        $buffer = '';
        while (mb_strlen($buffer, '8bit') < $length) {
            $result = $this->socket->recvLine($length - mb_strlen($buffer, '8bit'), $this->timeout);
            if ($result === '' || $result === false) {
                $this->throwException();
            }
            $buffer .= $result;
        }
        return $buffer;
    }

    public function getLine(): string
    {
        $buffer = '';
        // Reading stops at \r or \n. In case it stopped at \r we must continue reading.
        while (substr($buffer, -1, 1) !== "\n") {
            $result = $this->socket->recvLine(1024, $this->timeout);
            if ($result === '' || $result === false) {
                $this->throwException();
            }
            $buffer .= $result;
        }
        return rtrim($buffer);
    }

    public function disconnect(): void
    {
        $this->socket->close();
    }

}