<?php

namespace MSwoft\Beanstalk\Overwrite;

use Pheanstalk\Contract\SocketFactoryInterface;
use Pheanstalk\Contract\SocketInterface;

class SocketFactory implements SocketFactoryInterface
{
    private $connectTimeout;
    private $commandTimeout;
    private $host;
    private $port;

    public function __construct(string $host, int $port = 11300, float $connectTimeout = 1.0, float $commandTimeout = 3.0)
    {
        $this->host = $host;
        $this->port = $port;

        $this->connectTimeout = $connectTimeout;
        $this->commandTimeout = $commandTimeout;
    }

    public function create(): SocketInterface
    {
        return new SocketSocket($this->host, $this->port, $this->connectTimeout, $this->commandTimeout);
    }
}