<?php declare(strict_types=1);


namespace MSwoft\Beanstalk\Overwrite;

use Pheanstalk\Pheanstalk;

class BeanstalkdClient
{
    public static function create(string $host = null, int $port = null, $connectTimeout = 1, $commandTimeout = 3)
    {
        return Pheanstalk::createWithFactory(new SocketFactory($host, $port, $connectTimeout, $commandTimeout));
    }


    public static function watchOnly(string $tube)
    {
        return self::create()->watchOnly($tube);
    }

    public static function useTube(string $tube)
    {
        return self::create()->useTube($tube);
    }
}