<?php declare(strict_types=1);

namespace MSwoft\Beanstalk;

use MSwoft\Beanstalk\Connection\Connection;
use function bean;

/**
 * Class RedisDb
 *
 * @since 2.0
 */
class BeanstalkDb
{
    /**
     * @var string
     */
    private $host = '127.0.0.1';

    /**
     * @var int
     */
    private $port = 6379;

    /**
     * @var float
     */
    private $connectTimeout = 1.0;

    /**
     * @var float
     */
    private $commandTimeout = 5.0;

    /**
     * @param Pool $pool
     *
     * @return Connection
     */
    public function createConnection(Pool $pool): Connection
    {
        $connection = bean(Connection::class);
        $connection->initialize($pool, $this);
        $connection->create();

        return $connection;
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        return $this->host;
    }

    /**
     * @return int
     */
    public function getPort(): int
    {
        return (int)$this->port;
    }

    /**
     * @return float
     */
    public function getConnectTimeout(): float
    {
        return (float)$this->connectTimeout;
    }

    /**
     * @return float
     */
    public function getCommandTimeout(): float
    {
        return (float)$this->commandTimeout;
    }
}
