<?php declare(strict_types=1);


namespace MSwoft\Beanstalk;

use MSwoft\Helper\ComposerJSON;
use MSwoft\SwoftComponent;
use function bean;

/**
 * Class AutoLoader
 *
 * @since 2.0
 */
class AutoLoader extends SwoftComponent
{
    /**
     * @return array
     */
    public function getPrefixDirs(): array
    {
        return [
            __NAMESPACE__ => __DIR__,
        ];
    }

    /**
     * @return array
     */
    public function metadata(): array
    {
        $jsonFile = dirname(__DIR__) . '/composer.json';

        return ComposerJSON::open($jsonFile)->getMetadata();
    }

    /**
     * @return array
     */
    public function beans(): array
    {
        return [
            'beanstalk'      => [
                'class'  => BeanstalkDb::class,
            ],
            'beanstalk.pool' => [
                'class'   => Pool::class,
                'beanstalkDb' => bean('beanstalk'),
            ]
        ];
    }
}
