<?php declare(strict_types=1);


namespace MSwoft\Bean\Listener;


use MSwoft\Bean\BeanEvent;
use MSwoft\Bean\BeanFactory;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;

/**
 * Class DestroySessionListener
 *
 * @since 2.0
 *
 * @Listener(BeanEvent::DESTROY_SESSION)
 */
class DestroySessionListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        $id = (string)$event->getParam(0, '');
        if (empty($id)) {
            return;
        }

        BeanFactory::destroySession($id);
    }
}
