<?php declare(strict_types=1);

namespace MSwoft\Bean\Listener;

use MSwoft\Bean\BeanEvent;
use MSwoft\Bean\BeanFactory;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;

/**
 * Class DestroyRequestListener
 *
 * @since 2.0
 *
 * @Listener(BeanEvent::DESTROY_REQUEST)
 */
class DestroyRequestListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        $id = (string)$event->getParam(0, '');
        if (empty($id)) {
            return;
        }

        BeanFactory::destroyRequest($id);
    }
}
