<?php declare(strict_types=1);


namespace MSwoft\Bean\Annotation\Parser;


use ReflectionClass;
use ReflectionException;
use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Bean\Annotation\Mapping\Primary;
use MSwoft\Bean\InterfaceRegister;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class PrimaryParser
 *
 * @since 2.0
 *
 * @AnnotationParser(annotation=Primary::class)
 */
class PrimaryParser extends Parser
{
    /**
     * @param int     $type
     * @param Primary $annotationObject
     *
     * @return array
     * @throws ReflectionException
     * @throws ValidatorException
     */
    public function parse(int $type, $annotationObject): array
    {
        $rc = new ReflectionClass($this->className);

        $interfaces = $rc->getInterfaces();
        if (empty($interfaces)) {
            return [];
        }

        foreach ($interfaces as $interface) {
            InterfaceRegister::registerPrimary($interface->getName(), $this->className);
        }

        return [];
    }
}