<?php declare(strict_types=1);

namespace MSwoft\Aop;

use MSwoft\Aop\Ast\Visitor\ProxyVisitor;
use MSwoft\Proxy\Exception\ProxyException;
use MSwoft\Proxy\Proxy as BaseProxy;
use function explode;
use function strpos;

/**
 * Class Proxy
 *
 * @since 2.0
 */
class Proxy
{
    /**
     * New class name by proxy
     *
     * @param string $className
     *
     * @return string
     * @throws ProxyException
     */
    public static function newClassName(string $className): string
    {
        // Only proxy AOP class
        if (!Aop::matchClass($className)) {
            return $className;
        }

        // Is RPC proxy
        if (strpos($className, '_IGNORE_') !== false) {
            return $className;
        }

        $visitor = new ProxyVisitor();
        return BaseProxy::newClassName($className, $visitor);
    }

    /**
     * Get real class name
     *
     * @param string $proxyClassName
     *
     * @return string
     */
    public static function getClassName(string $proxyClassName): string
    {
        [$className] = explode('_', $proxyClassName);
        return $className;
    }

    /**
     * Get original class name
     *
     * @param string $proxyClassName
     *
     * @return string
     */
    public static function getOriginalClassName(string $proxyClassName): string
    {
        $proxies = explode(ProxyVisitor::PROXY, $proxyClassName);

        return $proxies[0];
    }
}
