<?php declare(strict_types=1);

namespace MSwoft\Aop\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Aop\Annotation\Mapping\Before;
use MSwoft\Aop\AspectRegister;
use MSwoft\Aop\Exception\AopException;

/**
 * Class BeforeParser
 *
 * @AnnotationParser(Before::class)
 *
 * @since 2.0
 */
class BeforeParser extends Parser
{
    /**
     * Parse `Before` annotation
     *
     * @param int    $type
     * @param Before $annotationObject
     *
     * @return array
     * @throws AopException
     */
    public function parse(int $type, $annotationObject): array
    {
        if ($type !== self::TYPE_METHOD) {
            throw new AopException('`@Before` must be defined by method!');
        }

        AspectRegister::registerAdvice(AspectRegister::ADVICE_BEFORE, $this->className, $this->methodName);

        return [];
    }
}