<?php declare(strict_types=1);

namespace MSwoft\Aop\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Aop\Annotation\Mapping\Around;
use MSwoft\Aop\AspectRegister;
use MSwoft\Aop\Exception\AopException;

/**
 * Class AroundParser
 *
 * @AnnotationParser(Around::class)
 *
 * @since 2.0
 */
class AroundParser extends Parser
{
    /**
     * Parse `Around` annotation
     *
     * @param int    $type
     * @param Around $annotationObject
     *
     * @return array
     * @throws AopException
     */
    public function parse(int $type, $annotationObject): array
    {
        if ($type !== self::TYPE_METHOD) {
            throw new AopException('`@Around` must be defined by method!');
        }

        AspectRegister::registerAdvice(AspectRegister::ADVICE_AROUND, $this->className, $this->methodName);

        return [];
    }
}