<?php declare(strict_types=1);

namespace MSwoft\Aop\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Aop\Annotation\Mapping\After;
use MSwoft\Aop\AspectRegister;
use MSwoft\Aop\Exception\AopException;

/**
 * Class AfterParser
 *
 * @AnnotationParser(After::class)
 *
 * @since 2.0
 */
class AfterParser extends Parser
{
    /**
     * Parse `After` annotation
     *
     * @param int   $type
     * @param After $annotationObject
     *
     * @return array
     * @throws AopException
     */
    public function parse(int $type, $annotationObject): array
    {
        if ($type !== self::TYPE_METHOD) {
            throw new AopException('`@After` must be defined by method!');
        }

        AspectRegister::registerAdvice(AspectRegister::ADVICE_AFTER, $this->className, $this->methodName);

        return [];
    }
}
